<?php

function deliciko_fw_ext_backups_demos( $demos ) {
	$demo_content_installer	 = 'https://digitly.pro';
	$demos_array			 = array(
		'default'			 => array(
			'title'			 => esc_html__( 'Digitly 3', 'deliciko' ),
			'screenshot'	 => esc_url( $demo_content_installer ) . 'https://c.files.bbci.co.uk/13FA7/production/_116513818_55660682.jpg',
			'preview_link'	 => esc_url( 'http://digitly.pro' ),
		),
		'defaultred'			 => array(
			'title'			 => esc_html__( 'Digitly 2', 'deliciko' ),
			'screenshot'	 => esc_url( $demo_content_installer ) . 'https://c.files.bbci.co.uk/13FA7/production/_116513818_55660682.jpg',
			'preview_link'	 => esc_url( 'http://digitly.pro' ),
		),
		'wpcafe-demo'			 => array(
			'title'			 => esc_html__( 'Digitly 1', 'deliciko' ),
			'screenshot'	 => esc_url( $demo_content_installer ) . 'https://c.files.bbci.co.uk/13FA7/production/_116513818_55660682.jpg',
			'preview_link'	 => esc_url( 'http://digitly.pro' ),
		),
		
	);
	$download_url			 = esc_url( $demo_content_installer ) . '#';
	foreach ( $demos_array as $id => $data ) {
		$demo						 = new FW_Ext_Backups_Demo( $id, 'piecemeal', array(
			'url'		 => $download_url,
			'file_id'	 => $id,
		) );
		$demo->set_title( $data[ 'title' ] );

		$demos[ $demo->get_id() ]	 = $demo;
		unset( $demo );
	}
	return $demos;
}

add_filter( 'fw:ext:backups-demo:demos', 'deliciko_fw_ext_backups_demos' );